import opentrons
import pandas as pd # Needed for many of my programs, but not this one
from opentrons import protocol_api

#Lines 6-8 are for simulation or Jupyter Notebook driving only This can be said also for all major commented sections. When doing simulations, uncomment all of the commented lines and comment out the "Run Only" lines
#import sys
#import json
#from opentrons.simulate import simulate, format_runlog






metadata = {
    'apiLevel': '2.9',
    'author': 'Justin Napolitano <jmnapol@g.clemson.edu>',
    'protocolName': 'Full 384 Well Plate Loading',

    'description': 'Protocol for loading a 384 well plate entirely, leaving wells for all 4 controls'
    } # Neccessary line for the majority of programs

def run(protocol: protocol_api.ProtocolContext):
    
     
    #with open('C:/Users/labadmin/Desktop/greiner_384_wellplate_25ul/1.json') as labware_file:
    #    data = labware_file.read()
    #labware_def = json.loads(data)
    #plate_6 = protocol.load_labware_from_definition(labware_def, 6)
    plate_6 = protocol.load_labware('greiner_384_wellplate_25ul', '6') #Run Only

    plate_positions = [] #This section creates a list of all locations on the plate, in order. This list can alternatively be imported from the part data
    letters = ['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P']
    for i in range (1,25,1):
        for j in range(0,16,1):
            plate_positions.append(letters[j] + str(i))


    #with open('C:/ProgramData/Anaconda3/Lib/site-packages/opentrons_shared_data/data/labware/definitions/2/opentrons_96_filtertiprack_20ul/1.json') as labware_file:
    #    data = labware_file.read() 
    #labware_def = json.loads(data)
    #tiprack_3 = protocol.load_labware_from_definition(labware_def, 3)
    #tiprack_9 = protocol.load_labware_from_definition(labware_def, 9)
    tiprack_3 = protocol.load_labware('opentrons_96_filtertiprack_20ul', '3') #Run Only
    tiprack_9 = protocol.load_labware('opentrons_96_filtertiprack_20ul', '9') #Run Only
    
    
    #with open('C:/ProgramData/Anaconda3/Lib/site-packages/opentrons_shared_data/data/labware/definitions/2/opentrons_6_tuberack_falcon_50ml_conical/1.json') as labware_file:
    #    data = labware_file.read() 
    #labware_def = json.loads(data)
    #rack_1 = protocol.load_labware_from_definition(labware_def, 1)
    #rack_2 = protocol.load_labware_from_definition(labware_def, 2)
    #rack_4 = protocol.load_labware_from_definition(labware_def, 4)
    #rack_5 = protocol.load_labware_from_definition(labware_def, 5)
    #rack_7 = protocol.load_labware_from_definition(labware_def, 7)
    #rack_8 = protocol.load_labware_from_definition(labware_def, 8)
    #rack_10 = protocol.load_labware_from_definition(labware_def, 10)
    #rack_11 = protocol.load_labware_from_definition(labware_def, 11)
    rack_1 = protocol.load_labware('opentrons_6_tuberack_falcon_50ml_conical', '1') #Run Only
    rack_2 = protocol.load_labware('opentrons_6_tuberack_falcon_50ml_conical', '2') #Run Only
    rack_4 = protocol.load_labware('opentrons_6_tuberack_falcon_50ml_conical', '4') #Run Only
    rack_5 = protocol.load_labware('opentrons_6_tuberack_falcon_50ml_conical', '5') #Run Only
    rack_7 = protocol.load_labware('opentrons_6_tuberack_falcon_50ml_conical', '7') #Run Only
    rack_8 = protocol.load_labware('opentrons_6_tuberack_falcon_50ml_conical', '8') #Run Only
    rack_10 = protocol.load_labware('opentrons_6_tuberack_falcon_50ml_conical', '10') #Run Only
    rack_11 = protocol.load_labware('opentrons_6_tuberack_falcon_50ml_conical', '11') #Run Only
    
    racks = [rack_1,rack_2,rack_4,rack_5,rack_7,rack_8,rack_10,rack_11]
    rack_positions = ['A1','A2','A3','B1','B2','B3']
    
    
    #with open('C:/ProgramData/Anaconda3/Lib/site-packages/opentrons_shared_data/data/labware/definitions/2/opentrons_1_trash_1100ml_fixed/1.json') as labware_file:
    #    data = labware_file.read() 
    #labware_def = json.loads(data)
    #trash = protocol.load_labware_from_definition(labware_def, 12)                                
    trash = protocol.load_labware('opentrons_1_trash_1100ml_fixed', '12') #Run Only (not neccessary for this program but is for some)
    
    
    robot_model = 'OT-2 Standard' #Not neccessary for this program but is for some
    
    
    #We use the p20, but I would recommend using the p10. Both the p10 and p20 have minimum pipetting volumes of 1 uL, but the p10 will have half the error of the p20
    pipettes = protocol.load_instrument('p20_single_gen2', mount='right', tip_racks=[tiprack_3, tiprack_9]) #To my memory, this line works for simulations and runs (but might actually not for simulations)
    pipettes.flow_rate.dispense = 1.5 #uL/s (Opentrons does not provide information on the minimum and maximum flowrate, to my knowledge)
    pipettes.flow_rate.aspirate = 1.5 #uL/s
    pipettes.flow_rate.blow_out = 48 #uL/s
    
    
    #This section is the loop that actually drives the robot. This loop will be very different for every protocol
    for q in range (0,4,1):
        for i in range(0,len(racks),1):
            if q != 3 or i != 7:
                for j in range(0,len(rack_positions),1):
                    k = (i * 6) + j + (q * 48)
                    m = k // 16
                    k = k + 16 * m
                    l = k + 16
                    pipettes.distribute(2,[racks[i].wells_by_name()[well_name] for well_name in [rack_positions[j]]], [plate_6.wells_by_name()[well_name_2] for well_name_2 in [plate_positions[k],plate_positions[l]]], disposal_volume = 1)
                    # The above line is the .distribute() command. First, I select the rack of conicals I want to aspirate from. Then, I selected the position on that rack to aspirate from. Then, I select the location(s) to dispense to (in this case, 2). Lastly, I set the disposal volume, which is blown out into the trash. This should be, at minimum, equal to the minimum volume and at most, equal to 10% of the maximum volume.
            else:
                for j in range(0,2,1):
                    k = (i * 6) + j + (q * 48)
                    m = k // 16
                    k = k + 16 * m
                    l = k + 16
                    pipettes.distribute(2,[racks[i].wells_by_name()[well_name] for well_name in [rack_positions[j]]], [plate_6.wells_by_name()[well_name_2] for well_name_2 in [plate_positions[k],plate_positions[l]]], disposal_volume = 1)
        if q < 3:
            protocol.pause('End of Quarter ' + str(q+1)) #This pauses the code and requires user input to continue driving
